<?php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ApiKoneksiSarpras;
use App\Models\InventarisGuru;
use App\Models\SarprasSyncLog;
use Illuminate\Support\Facades\Http;

class AdminApiSarprasController extends Controller
{
    public function index()
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $koneksi = ApiKoneksiSarpras::orderBy('id','desc')->get();
        return view('admin.api_sarpras.koneksi_index', compact('koneksi'));
    }

    public function logs()
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $logs = SarprasSyncLog::orderBy('id','desc')->get();
        return view('admin.api_sarpras.logs', compact('logs'));
    }
    
    // ✅ TAMBAH: Create koneksi
    public function create()
    {
        if (!session('admin_id')) return redirect()->route('login');
        return view('admin.api_sarpras.create');
    }
    
    // ✅ TAMBAH: Store koneksi
    public function store(Request $r)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        ApiKoneksiSarpras::create([
            'nama_aplikasi' => $r->input('nama_aplikasi'),
            'endpoint_url' => $r->input('endpoint_url'),
            'token_plain' => $r->input('token_plain'),
            'aktif' => $r->input('aktif') ? 1 : 0
        ]);
        
        return redirect()->route('admin.api.sarpras.index')->with('success', 'Koneksi berhasil ditambahkan');
    }

    public function sync(Request $r)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $koneksi = ApiKoneksiSarpras::where('aktif',1)->first();
        if (!$koneksi) {
            SarprasSyncLog::create([
                'tipe_data' => 'inventaris_guru',
                'status' => 'failed',
                'pesan' => 'Tidak ada koneksi aktif'
            ]);
            return back()->with('error', 'Tidak ada koneksi aktif');
        }

        $toSync = InventarisGuru::where('sync_sarpras', 0)->get();

        foreach ($toSync as $item) {
            $payload = [
                'kode_barang' => $item->kode_barang,
                'nama_barang' => $item->nama_barang,
                'jumlah' => $item->jumlah,
                'kondisi' => $item->kondisi,
                'lokasi' => $item->lokasi,
                'id_guru' => $item->id_guru
            ];

            try {
                $response = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $koneksi->token_plain
                ])->post($koneksi->endpoint_url, $payload);

                if ($response->successful()) {
                    $item->sync_sarpras = 1;
                    $item->save();

                    SarprasSyncLog::create([
                        'id_koneksi' => $koneksi->id,
                        'tipe_data' => 'inventaris_guru',
                        'payload' => json_encode($payload),
                        'status' => 'success',
                        'pesan' => 'OK'
                    ]);
                } else {
                    SarprasSyncLog::create([
                        'id_koneksi' => $koneksi->id,
                        'tipe_data' => 'inventaris_guru',
                        'payload' => json_encode($payload),
                        'status' => 'failed',
                        'pesan' => 'HTTP ' . $response->status()
                    ]);
                }
            } catch (\Exception $e) {
                SarprasSyncLog::create([
                    'id_koneksi' => $koneksi->id,
                    'tipe_data' => 'inventaris_guru',
                    'payload' => json_encode($payload),
                    'status' => 'failed',
                    'pesan' => $e->getMessage()
                ]);
            }
        }

        $koneksi->last_sync = now();
        $koneksi->save();

        return back()->with('success', 'Sync selesai');
    }
}