<?php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AturanPeminjaman;

class AdminAturanController extends Controller
{
    public function index()
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $aturan = AturanPeminjaman::orderBy('id','desc')->get();
        return view('admin.aturan.index', compact('aturan'));
    }

    public function edit($id)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $row = AturanPeminjaman::findOrFail($id);
        return view('admin.aturan.edit', compact('row'));
    }

    public function update(Request $r, $id)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $a = AturanPeminjaman::findOrFail($id);
        $a->update([
            'nama' => $r->input('nama'),
            'deskripsi' => $r->input('deskripsi'),
            'maksimal_hari' => (int) $r->input('maksimal_hari'),
            'denda_per_hari' => $r->input('denda_per_hari'),
            'perlu_persetujuan_guru' => $r->input('perlu_persetujuan_guru') ? 1 : 0,
            'aktif' => $r->input('aktif') ? 1 : 0
        ]);

        return redirect()->route('admin.aturan.index')->with('success', 'Aturan berhasil diupdate');
    }
}