<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PersetujuanSarpras extends Model
{
    protected $table = 'persetujuan_sarpras';
    protected $primaryKey = 'id';
    public $timestamps = false;

    protected $fillable = [
        'id_guru',
        'id_aturan',
        'setuju',
        'tanggal_setuju',
        'catatan'
    ];

    public function guru()
    {
        return $this->belongsTo(Guru::class, 'id_guru');
    }

    public function aturan()
    {
        return $this->belongsTo(AturanPeminjaman::class, 'id_aturan');
    }
}
