@extends('layouts.admin')

@section('title', 'Logs Sync Sarpras')

@section('content')
<div class="container-fluid py-4">
    <h3 class="mb-4">Logs Sinkronisasi Sarpras</h3>

    <div class="card shadow-sm">
        <div class="card-body">
            <table class="table table-bordered table-striped" id="datatable">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Koneksi</th>
                        <th>Tipe Data</th>
                        <th>Payload</th>
                        <th>Status</th>
                        <th>Pesan</th>
                        <th>Waktu</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($logs as $l)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $l->koneksi ? $l->koneksi->nama_aplikasi : '-' }}</td>
                        <td>{{ $l->tipe_data }}</td>
                        <td><pre>{{ $l->payload }}</pre></td>
                        <td>
                            <span class="badge {{ $l->status == 'success' ? 'bg-success' : 'bg-danger' }}">
                                {{ ucfirst($l->status) }}
                            </span>
                        </td>
                        <td>{{ $l->pesan }}</td>
                        <td>{{ \Carbon\Carbon::parse($l->created_at)->format('d-m-Y H:i:s') }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        $('#datatable').DataTable({
            "order": [[ 0, "desc" ]]
        });
    });
</script>
@endpush
@endsection
