@extends('layouts.admin')
@section('title', 'Daftar Bahan Praktik')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h3 class="fw-bold">Daftar Bahan Praktik</h3>
    <a href="{{ route('admin.bahan.create') }}" class="btn btn-primary rounded-3 px-4">
        <i class="fa fa-plus me-2"></i> Tambah Bahan
    </a>
</div>

<div class="card shadow-sm rounded-4 p-3">
    <div class="table-responsive">
        <table class="table table-striped table-bordered align-middle" id="datatable">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Kode</th>
                    <th>Nama</th>
                    <th>Stok</th>
                    <th>Satuan</th>
                    <th>Keterangan</th>
                    <th width="130px">Aksi</th>
                </tr>
            </thead>
            <tbody>
                @forelse($bahan as $i => $b)
                <tr>
                    <td>{{ $i+1 }}</td>
                    <td>{{ $b->kode }}</td>
                    <td>{{ $b->nama }}</td>
                    <td>{{ $b->stok }}</td>
                    <td>{{ $b->satuan }}</td>
                    <td>{{ $b->keterangan ?? '-' }}</td>
                    <td>
                        <form action="{{ route('admin.bahan.delete', $b->id) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-sm btn-danger rounded-3" onclick="return confirm('Hapus bahan?')">
                                <i class="fa fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="text-center py-3 text-muted">
                        Tidak ada data bahan praktik.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function(){
    $('#datatable').DataTable({"order":[[0,"desc"]]});
});
</script>
@endpush
@endsection
