@extends('layouts.admin')

@section('title', 'Edit Inventaris')

@section('content')
<h4 class="fw-bold mb-3">Edit Inventaris</h4>

<div class="card shadow-sm">
    <div class="card-body">

        <form action="{{ route('admin.inventaris.update', $row->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="row">

                <div class="col-md-6 mb-3">
                    <label>Kode Barang</label>
                    <input type="text" name="kode_barang" class="form-control"
                           value="{{ $row->kode_barang }}" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Nama Barang</label>
                    <input type="text" name="nama_barang" class="form-control"
                           value="{{ $row->nama_barang }}" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Kategori</label>
                    <select name="id_kategori" class="form-control">
                        <option value="">-- Tidak Ada Kategori --</option>

                        @foreach ($kategori as $k)
                        <option value="{{ $k->id }}"
                            {{ $row->id_kategori == $k->id ? 'selected' : '' }}>
                            {{ $k->nama }}
                        </option>
                        @endforeach

                    </select>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Jumlah</label>
                    <input type="number" name="jumlah" class="form-control"
                           value="{{ $row->jumlah }}" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Kondisi</label>
                    <input type="text" name="kondisi" class="form-control"
                           value="{{ $row->kondisi }}">
                </div>

                <div class="col-md-6 mb-3">
                    <label>Lokasi</label>
                    <input type="text" name="lokasi" class="form-control"
                           value="{{ $row->lokasi }}">
                </div>

                <div class="col-12 mb-3">
                    <label>Keterangan</label>
                    <textarea name="keterangan" class="form-control" rows="3">{{ $row->keterangan }}</textarea>
                </div>

            </div>

            <button class="btn btn-primary">
                <i class="fa fa-save me-1"></i> Update
            </button>

            <a href="{{ route('admin.inventaris.index') }}" class="btn btn-secondary">Kembali</a>

        </form>

    </div>
</div>
@endsection
