@extends('layouts.admin')
@section('title', 'Data Inventaris')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h3 class="fw-bold">Data Inventaris</h3>
    <a href="{{ route('admin.inventaris.create') }}" class="btn btn-primary rounded-3 px-4">
        <i class="fa fa-plus me-2"></i> Tambah Inventaris
    </a>
</div>

<div class="card shadow-sm rounded-4 p-3">
    <div class="table-responsive">
        <table class="table table-striped table-bordered align-middle" id="datatable">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Kode</th>
                    <th>Nama Barang</th>
                    <th>Kategori</th>
                    <th>Jumlah</th>
                    <th>Kondisi</th>
                    <th>Lokasi</th>
                    <th width="130px">Aksi</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($inventaris as $i)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $i->kode_barang }}</td>
                    <td>{{ $i->nama_barang }}</td>
                    <td>{{ $i->kategori->nama ?? '-' }}</td>
                    <td>{{ $i->jumlah }}</td>
                    <td>{{ $i->kondisi }}</td>
                    <td>{{ $i->lokasi }}</td>
                    <td>
                        <a href="{{ route('admin.inventaris.edit', $i->id) }}" class="btn btn-sm btn-warning rounded-3">
                            <i class="fa fa-edit"></i>
                        </a>
                        <form action="{{ route('admin.inventaris.delete', $i->id) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-sm btn-danger rounded-3" onclick="return confirm('Hapus inventaris?')">
                                <i class="fa fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function(){
    $('#datatable').DataTable({"order":[[0,"desc"]]});
});
</script>
@endpush
@endsection
