@extends('layouts.guru')
@section('title','Detail Penggunaan')

@section('content')
<div class="card shadow-sm">
    <div class="card-body">
        <h5 class="mb-3">{{ $penggunaan->kode_penggunaan }}</h5>

        <div class="row mb-3">
            <div class="col-md-6"><b>Siswa:</b> {{ $penggunaan->siswa->nama }}</div>
            <div class="col-md-6"><b>Tanggal:</b> {{ $penggunaan->tanggal }}</div>
        </div>

        @if($penggunaan->keterangan)
        <p class="text-muted">{{ $penggunaan->keterangan }}</p>
        @endif

        <div class="table-responsive">
            <table class="table table-bordered align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Bahan</th>
                        <th>Jumlah</th>
                        <th>Satuan</th>
                        <th>Keterangan</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($penggunaan->detail as $d)
                    <tr>
                        <td>{{ $d->bahan->nama }}</td>
                        <td>{{ $d->jumlah }}</td>
                        <td>{{ $d->satuan }}</td>
                        <td>{{ $d->keterangan ?? '-' }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <a href="{{ route('guru.penggunaan_bahan.index') }}" class="btn btn-secondary btn-sm">
            Kembali
        </a>
    </div>
</div>
@endsection
