@extends('layouts.guru')
@section('title','Penggunaan Bahan')

@section('content')
<div class="card shadow-sm">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Penggunaan Bahan</h5>
        <a href="{{ route('guru.penggunaan_bahan.create') }}" class="btn btn-primary btn-sm">
            <i class="fa fa-plus"></i> Tambah
        </a>
    </div>

    <div class="table-responsive">
        <table class="table table-hover align-middle mb-0">
            <thead class="table-light">
                <tr>
                    <th>Kode</th>
                    <th>Siswa</th>
                    <th>Tanggal</th>
                    <th width="100">Aksi</th>
                </tr>
            </thead>
            <tbody>
                @forelse($penggunaan as $p)
                <tr>
                    <td>{{ $p->kode_penggunaan }}</td>
                    <td>{{ $p->siswa->nama ?? '-' }}</td>
                    <td>{{ \Carbon\Carbon::parse($p->tanggal)->format('d/m/Y') }}</td>
                    <td>
                        <a href="{{ route('guru.penggunaan_bahan.detail',$p->id) }}"
                           class="btn btn-info btn-sm w-100">
                           Detail
                        </a>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="4" class="text-center text-muted">Belum ada data</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
