<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SI Inventaris TKJT</title>

    <!-- Bootstrap 5 & Font Awesome -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            scroll-behavior: smooth;
            background: #f4f6f9;
        }

        /* Hero Section */
        .hero {
            background: linear-gradient(rgba(0, 50, 100, 0.8), rgba(0, 80, 160, 0.9)), 
                        url('https://images.unsplash.com/photo-1612832021020-4c7cf4d0dbb5?auto=format&fit=crop&w=1600&q=80') center/cover no-repeat;
            height: 80vh;
            display: flex;
            justify-content: center;
            align-items: center;
            position: relative;
            overflow: hidden;
            color: #fff;
        }

        .hero-content {
            position: relative;
            z-index: 2;
            text-align: center;
            padding: 2rem;
        }

        .hero h1 {
            font-size: 3.5rem;
            font-weight: 800;
            margin-bottom: 1rem;
            text-shadow: 2px 2px 8px rgba(0,0,0,0.3);
        }

        .hero p {
            font-size: 1.2rem;
            max-width: 600px;
            margin: 0 auto 2rem;
            opacity: 0.9;
        }

        .btn-login-main {
            background: #50e3c2;
            color: #0d3b66;
            border: none;
            padding: 1rem 2.5rem;
            font-size: 1.2rem;
            font-weight: 600;
            border-radius: 12px;
            transition: all 0.3s;
            box-shadow: 0 8px 25px rgba(80, 227, 194, 0.4);
        }

        .btn-login-main:hover {
            background: #3bc9b0;
            transform: translateY(-3px);
            box-shadow: 0 12px 30px rgba(80, 227, 194, 0.6);
        }

        /* Statistik Section */
        .stat-box {
            border-radius: 16px;
            padding: 2rem 1.5rem;
            color: #fff;
            text-align: center;
            box-shadow: 0 6px 20px rgba(0,0,0,0.15);
            transition: transform 0.3s, box-shadow 0.3s;
            height: 100%;
        }

        .stat-box:hover { 
            transform: translateY(-5px);
            box-shadow: 0 12px 25px rgba(0,0,0,0.25);
        }

        .stat-box i {
            font-size: 2.5rem;
            margin-bottom: 1rem;
            opacity: 0.9;
        }

        .stat-box h3 {
            font-size: 2.5rem;
            font-weight: 700;
            margin: 0.5rem 0;
        }

        .stat-box p {
            font-size: 1rem;
            opacity: 0.9;
            margin: 0;
        }

        /* Feature Cards */
        .feature-card {
            border-radius: 16px;
            padding: 2rem;
            background: white;
            box-shadow: 0 8px 25px rgba(0,0,0,0.08);
            transition: all 0.3s;
            height: 100%;
            border: none;
            text-align: center;
        }

        .feature-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.15);
        }

        .feature-icon {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
            font-size: 2rem;
            color: white;
        }

        /* Role Cards */
        .role-card {
            border-radius: 16px;
            padding: 2.5rem 1.5rem;
            text-align: center;
            transition: all 0.3s;
            box-shadow: 0 8px 25px rgba(0,0,0,0.08);
            height: 100%;
            position: relative;
            overflow: hidden;
            color: white;
            border: none;
        }

        .role-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: rgba(255,255,255,0.3);
        }

        .role-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 15px 35px rgba(0,0,0,0.2);
        }

        .role-icon {
            font-size: 3.5rem;
            margin-bottom: 1.5rem;
            opacity: 0.9;
        }

        .role-btn {
            background: rgba(255,255,255,0.2);
            border: 1px solid rgba(255,255,255,0.3);
            color: white;
            padding: 0.6rem 1.5rem;
            border-radius: 8px;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-block;
            margin-top: 1rem;
        }

        .role-btn:hover {
            background: rgba(255,255,255,0.3);
            color: white;
            transform: scale(1.05);
        }

        /* Inventaris Cards */
        .card-inventaris {
            border-radius: 16px;
            transition: transform 0.3s, box-shadow 0.3s;
            border: 1px solid rgba(0,0,0,0.05);
            height: 100%;
        }

        .card-inventaris:hover {
            transform: translateY(-8px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.15);
        }

        /* Footer */
        footer {
            background: #0d3b66;
            color: #fff;
            padding: 3rem 0 1.5rem;
            text-align: center;
        }

        .footer-links a {
            color: #50e3c2;
            text-decoration: none;
            margin: 0 1rem;
            transition: color 0.3s;
        }

        .footer-links a:hover {
            color: white;
            text-decoration: underline;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .hero h1 {
                font-size: 2.5rem;
            }
            
            .hero p {
                font-size: 1rem;
            }
            
            .stat-box {
                padding: 1.5rem 1rem;
            }
            
            .stat-box h3 {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>

<!-- Hero Section -->
<section class="hero">
    <div class="hero-content">
        <h1>SI Inventaris TKJT</h1>
        <p>Sistem Manajemen Inventaris Jurusan Teknik Komputer dan Jaringan Terpadu</p>
        <a href="{{ route('login') }}" class="btn btn-login-main">
            <i class="fa-solid fa-right-to-bracket"></i> Login Sekarang
        </a>
        <p class="mt-3" style="opacity: 0.8; font-size: 0.9rem;">
            Login sebagai Admin, Guru, atau Siswa
        </p>
    </div>
</section>

<!-- Statistik Section -->
<section class="py-5">
    <div class="container">
        <h2 class="text-center mb-5">Statistik Sistem</h2>
        <div class="row g-4">
            <div class="col-md-3 col-6">
                <div class="stat-box" style="background: linear-gradient(135deg, #4a90e2, #3b78c1);">
                    <i class="fa-solid fa-user-graduate"></i>
                    <h3>{{ $statistik['total_siswa'] ?? '0' }}</h3>
                    <p>Siswa</p>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="stat-box" style="background: linear-gradient(135deg, #50e3c2, #3bc9b0);">
                    <i class="fa-solid fa-chalkboard-user"></i>
                    <h3>{{ $statistik['total_guru'] ?? '0' }}</h3>
                    <p>Guru</p>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="stat-box" style="background: linear-gradient(135deg, #f39c12, #e67e22);">
                    <i class="fa-solid fa-boxes-stacked"></i>
                    <h3>{{ $statistik['total_inventaris'] ?? '0' }}</h3>
                    <p>Inventaris</p>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="stat-box" style="background: linear-gradient(135deg, #9b59b6, #8e44ad);">
                    <i class="fa-solid fa-flask"></i>
                    <h3>{{ $statistik['total_bahan'] ?? '0' }}</h3>
                    <p>Bahan Praktik</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Fitur Utama -->
<section class="py-5 bg-light">
    <div class="container">
        <h2 class="text-center mb-5">Fitur Utama</h2>
        <div class="row g-4">
            <div class="col-md-4">
                <div class="feature-card">
                    <div class="feature-icon" style="background: linear-gradient(135deg, #4a90e2, #3b78c1);">
                        <i class="fa-solid fa-boxes-stacked"></i>
                    </div>
                    <h4>Manajemen Inventaris</h4>
                    <p>Kelola alat dan bahan praktik dengan sistem pencatatan yang terstruktur dan real-time.</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="feature-card">
                    <div class="feature-icon" style="background: linear-gradient(135deg, #50e3c2, #3bc9b0);">
                        <i class="fa-solid fa-handshake"></i>
                    </div>
                    <h4>Sistem Peminjaman</h4>
                    <p>Proses peminjaman alat dengan workflow approval dari guru dan admin.</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="feature-card">
                    <div class="feature-icon" style="background: linear-gradient(135deg, #f39c12, #e67e22);">
                        <i class="fa-solid fa-chart-line"></i>
                    </div>
                    <h4>Laporan & Analisis</h4>
                    <p>Monitor penggunaan inventaris dengan dashboard dan laporan statistik.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Login Berdasarkan Role -->
<section class="py-5">
    <div class="container">
        <h2 class="text-center mb-5">Login Sesuai Peran</h2>
        <div class="row g-4">
            <div class="col-md-4">
                <div class="role-card" style="background: linear-gradient(135deg, #4a90e2, #3b78c1);">
                    <div class="role-icon">
                        <i class="fa-solid fa-user-shield"></i>
                    </div>
                    <h3>Administrator</h3>
                    <p>Kelola data master, user, inventaris, dan monitoring sistem.</p>
                    <a href="{{ route('login') }}" class="role-btn">
                        <i class="fa-solid fa-right-to-bracket"></i> Login Admin
                    </a>
                </div>
            </div>
            <div class="col-md-4">
                <div class="role-card" style="background: linear-gradient(135deg, #50e3c2, #3bc9b0);">
                    <div class="role-icon">
                        <i class="fa-solid fa-chalkboard-user"></i>
                    </div>
                    <h3>Guru</h3>
                    <p>Kelola inventaris pribadi, setujui peminjaman, pantau penggunaan bahan.</p>
                    <a href="{{ route('login') }}" class="role-btn">
                        <i class="fa-solid fa-right-to-bracket"></i> Login Guru
                    </a>
                </div>
            </div>
            <div class="col-md-4">
                <div class="role-card" style="background: linear-gradient(135deg, #f39c12, #e67e22);">
                    <div class="role-icon">
                        <i class="fa-solid fa-user-graduate"></i>
                    </div>
                    <h3>Siswa</h3>
                    <p>Pinjam alat praktik, catat penggunaan bahan, dan pantau riwayat.</p>
                    <a href="{{ route('login') }}" class="role-btn">
                        <i class="fa-solid fa-right-to-bracket"></i> Login Siswa
                    </a>
                </div>
            </div>
        </div>
        <div class="text-center mt-4">
            <p class="text-muted">
                <i class="fa-solid fa-circle-info"></i>
                Pilih peran Anda saat login di halaman berikutnya
            </p>
        </div>
    </div>
</section>

<!-- Inventaris Terbaru -->
<section class="py-5 bg-light">
    <div class="container">
        <h2 class="text-center mb-4">Inventaris Terbaru</h2>
        <div class="row g-4">
            @if(isset($inventaris) && count($inventaris) > 0)
                @foreach($inventaris as $item)
                <div class="col-md-4">
                    <div class="card card-inventaris shadow-sm">
                        <div class="card-body">
                            <h5 class="card-title">{{ $item->nama_barang }}</h5>
                            <p class="card-text">
                                <i class="fa-solid fa-layer-group text-primary"></i> 
                                <strong>Kategori:</strong> {{ $item->kategori_nama ?? '-' }}
                            </p>
                            <p class="card-text">
                                <i class="fa-solid fa-hashtag text-success"></i> 
                                <strong>Kode:</strong> {{ $item->kode_barang }}
                            </p>
                            <p class="card-text">
                                <i class="fa-solid fa-boxes text-warning"></i> 
                                <strong>Jumlah:</strong> {{ $item->jumlah }}
                            </p>
                            <p class="card-text">
                                <i class="fa-solid fa-check-circle {{ $item->kondisi == 'Baik' ? 'text-success' : 'text-warning' }}"></i> 
                                <strong>Kondisi:</strong> {{ $item->kondisi }}
                            </p>
                            <p class="card-text">
                                <i class="fa-solid fa-map-marker-alt text-info"></i> 
                                <small class="text-muted">Lokasi: {{ $item->lokasi }}</small>
                            </p>
                        </div>
                    </div>
                </div>
                @endforeach
            @else
                <div class="col-12 text-center">
                    <div class="alert alert-info">
                        <i class="fa-solid fa-info-circle"></i> Data inventaris akan ditampilkan di sini
                    </div>
                </div>
            @endif
        </div>
    </div>
</section>

<!-- Footer -->
<footer>
    <div class="container">
        <div class="row">
            <div class="col-md-4">
                <h5><i class="fa-solid fa-school"></i> SI Inventaris TKJT</h5>
                <p>Sistem manajemen inventaris untuk Jurusan Teknik Komputer dan Jaringan.</p>
            </div>
            <div class="col-md-4">
                <h5>Link Cepat</h5>
                <div class="footer-links">
                    <a href="{{ route('home') }}"><i class="fa-solid fa-home"></i> Beranda</a><br>
                    <a href="{{ route('login') }}"><i class="fa-solid fa-right-to-bracket"></i> Login</a><br>
                    <a href="#"><i class="fa-solid fa-circle-info"></i> Tentang</a>
                </div>
            </div>
            <div class="col-md-4">
                <h5>Kontak</h5>
                <p>
                    <i class="fa-solid fa-location-dot"></i> Laboratorium TKJT<br>
                    <i class="fa-solid fa-phone"></i> (021) 1234-5678<br>
                    <i class="fa-solid fa-envelope"></i> inventaris@tkjt.sch.id
                </p>
            </div>
        </div>
        <hr style="border-color: rgba(255,255,255,0.1);">
        <div class="text-center pt-3">
            <p>&copy; {{ date('Y') }} SI Inventaris TKJT. All Rights Reserved.</p>
            <p class="small" style="opacity: 0.7;">
                Dibangun dengan <i class="fa-solid fa-heart text-danger"></i> untuk pendidikan
            </p>
        </div>
    </div>
</footer>

<!-- JavaScript -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
    // Animasi sederhana untuk statistik
    document.addEventListener('DOMContentLoaded', function() {
        // Highlight active nav
        const currentPath = window.location.pathname;
        document.querySelectorAll('nav a').forEach(link => {
            if (link.getAttribute('href') === currentPath) {
                link.classList.add('active');
            }
        });
        
        // Smooth scroll untuk anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({ behavior: 'smooth' });
                }
            });
        });
    });
</script>
</body>
</html>