<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Siswa - @yield('title', 'Dashboard')</title>

    <!-- Bootstrap 5 & Font Awesome -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <style>
        body {
            background: #f8fafc;
            font-family: 'Segoe UI', system-ui, sans-serif;
        }
        .navbar-brand {
            font-weight: 600;
        }
        .nav-link {
            border-radius: 8px;
            margin: 0 5px;
            transition: all 0.3s;
        }
        .nav-link:hover {
            background: rgba(255,255,255,0.15);
            transform: translateY(-2px);
        }
        .nav-link.active {
            background: rgba(255,255,255,0.2);
            font-weight: 600;
        }
        .content {
            padding: 20px;
            min-height: calc(100vh - 140px);
        }
        /* Bottom Navigation - Mobile Only */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            box-shadow: 0 -4px 12px rgba(0,0,0,0.1);
            display: flex;
            z-index: 1030;
        }
        .bottom-nav a {
            flex: 1;
            text-align: center;
            padding: 12px 0;
            color: #6c757d;
            text-decoration: none;
            transition: all 0.3s;
        }
        .bottom-nav a.active {
            color: #4a90e2;
            background: rgba(74, 144, 226, 0.05);
        }
        .bottom-nav i {
            font-size: 20px;
            display: block;
            margin-bottom: 4px;
        }
        .bottom-nav span {
            font-size: 11px;
            font-weight: 500;
        }
        /* Desktop padding adjustment */
        @media (min-width: 768px) {
            .content {
                padding-bottom: 20px;
            }
        }
    </style>
    
    @stack('styles')
</head>
<body>
    <!-- Top Navbar - Desktop & Mobile -->
    <nav class="navbar navbar-expand-lg navbar-dark shadow-lg" style="background: linear-gradient(135deg, #4a90e2, #50e3c2);">
        <div class="container-fluid">
            <!-- Brand & Toggle for mobile -->
            <a class="navbar-brand" href="{{ route('siswa.dashboard') }}">
                <i class="fa-solid fa-user-graduate me-2"></i>
                <span class="d-none d-md-inline">Siswa Portal</span>
                <span class="d-md-none">Siswa</span>
            </a>
            
            <!-- Desktop Navigation -->
            <div class="collapse navbar-collapse d-none d-md-flex">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('siswa.dashboard') ? 'active' : '' }}" 
                           href="{{ route('siswa.dashboard') }}">
                            <i class="fa-solid fa-gauge-high me-1"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->is('siswa/peminjaman*') ? 'active' : '' }}" 
                           href="{{ route('siswa.peminjaman.index') }}">
                            <i class="fa-solid fa-box me-1"></i> Peminjaman
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->is('siswa/penggunaan*') ? 'active' : '' }}" 
                           href="{{ route('siswa.penggunaan_bahan.index') }}">
                            <i class="fa-solid fa-flask-vial me-1"></i> Bahan Praktik
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('siswa.profil') ? 'active' : '' }}" 
                           href="{{ route('siswa.profil') }}">
                            <i class="fa-solid fa-user me-1"></i> Profil
                        </a>
                    </li>
                </ul>
                
                <!-- Logout Button - Desktop -->
                <form method="POST" action="{{ route('logout') }}" class="d-none d-md-block">
                    @csrf
                    <button class="btn btn-outline-light btn-sm shadow-sm">
                        <i class="fa-solid fa-right-from-bracket me-1"></i> Logout
                    </button>
                </form>
            </div>
            
            <!-- Mobile Menu Toggle & Logout -->
            <div class="d-flex d-md-none align-items-center">
                <form method="POST" action="{{ route('logout') }}" class="me-2">
                    @csrf
                    <button class="btn btn-outline-light btn-sm shadow-sm">
                        <i class="fa-solid fa-right-from-bracket"></i>
                    </button>
                </form>
                <button class="navbar-toggler border-0" type="button" data-bs-toggle="collapse" data-bs-target="#mobileMenu">
                    <i class="fa-solid fa-bars"></i>
                </button>
            </div>
        </div>
        

    </nav>

    <!-- Main Content -->
    <main class="content container-fluid">
        <!-- Flash Messages -->
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show shadow-sm mb-4">
                <i class="fa-solid fa-circle-check me-2"></i> {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show shadow-sm mb-4">
                <i class="fa-solid fa-circle-exclamation me-2"></i> {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif
        
        <!-- Page Content -->
        <div class="shadow-sm bg-white rounded-3 p-4 mb-4">
            @yield('content')
        </div>
    </main>

    <!-- Bottom Navigation - Mobile Only -->
    <nav class="bottom-nav d-md-none">
        <a href="{{ route('siswa.dashboard') }}" 
           class="{{ request()->routeIs('siswa.dashboard') ? 'active' : '' }}">
            <i class="fa-solid fa-gauge-high"></i>
            <span>Dashboard</span>
        </a>
        <a href="{{ route('siswa.peminjaman.index') }}" 
           class="{{ request()->is('siswa/peminjaman*') ? 'active' : '' }}">
            <i class="fa-solid fa-box"></i>
            <span>Peminjaman</span>
        </a>
        <a href="{{ route('siswa.penggunaan_bahan.index') }}" 
           class="{{ request()->is('siswa/penggunaan*') ? 'active' : '' }}">
            <i class="fa-solid fa-flask-vial"></i>
            <span>Bahan</span>
        </a>
        <a href="{{ route('siswa.profil') }}" 
           class="{{ request()->routeIs('siswa.profil') ? 'active' : '' }}">
            <i class="fa-solid fa-user"></i>
            <span>Profil</span>
        </a>
    </nav>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Auto-dismiss alerts after 5 seconds
        setTimeout(() => {
            document.querySelectorAll('.alert').forEach(alert => {
                alert.classList.remove('show');
            });
        }, 5000);
        
        // Close mobile menu when clicking outside
        document.addEventListener('click', (e) => {
            const mobileMenu = document.getElementById('mobileMenu');
            const toggler = document.querySelector('.navbar-toggler');
            if (mobileMenu.classList.contains('show') && 
                !mobileMenu.contains(e.target) && 
                !toggler.contains(e.target)) {
                new bootstrap.Collapse(mobileMenu).hide();
            }
        });
        
        // Active state for bottom nav
        document.querySelectorAll('.bottom-nav a').forEach(link => {
            link.addEventListener('click', function() {
                document.querySelectorAll('.bottom-nav a').forEach(a => a.classList.remove('active'));
                this.classList.add('active');
            });
        });
    </script>
    
    @stack('scripts')
</body>
</html>